<?php

/**
 * @package		Joomla.Administrator
 * @subpackage	com_contact
 * @copyright	Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */
// no direct access
defined('_JEXEC') or die;
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
$function = JRequest::getCmd('function', 'jSelectContact');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
echo JRoute::_('index.php?option=com_contact&view=contacts&layout=modal&tmpl=component&function=' . $function);
echo JText::_('JSEARCH_FILTER_LABEL');
echo $this->escape($this->state->get('filter.search'));
echo JText::_('COM_CONTACT_FILTER_SEARCH_DESC');
echo JText::_('JSEARCH_FILTER_SUBMIT');
echo JText::_('JSEARCH_FILTER_CLEAR');
echo JText::_('JOPTION_SELECT_ACCESS');
echo JHtml::_('select.options', JHtml::_('access.assetgroups'), 'value', 'text', $this->state->get('filter.access'));
echo JText::_('JOPTION_SELECT_PUBLISHED');
echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.published'), true);
echo JText::_('JOPTION_SELECT_CATEGORY');
?></option>
				<?php 
echo JHtml::_('select.options', JHtml::_('category.options', 'com_contact'), 'value', 'text', $this->state->get('filter.category_id'));
?>
			</select>
			<select name="filter_language" class="inputbox" onchange="this.form.submit()">
				<option value=""><?php 
echo JText::_('JOPTION_SELECT_LANGUAGE');
?></option>
				<?php 
echo JHtml::_('select.options', JHtml::_('contentlanguage.existing', true, true), 'value', 'text', $this->state->get('filter.language'));
?>
			</select>
		</div>
	</fieldset>

	<table class="adminlist">
		<thead>
			<tr>
				<th class="title">
					<?php 
echo JHtml::_('grid.sort', 'JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder);
?>
				</th>
				<th>
					<?php 
echo JHtml::_('grid.sort', 'COM_CONTACT_FIELD_LINKED_USER_LABEL', 'ul.name', $listDirn, $listOrder);
?>
				</th>
				<th width="15%">
					<?php 
echo JHtml::_('grid.sort', 'JGRID_HEADING_ACCESS', 'access_level', $listDirn, $listOrder);
?>
				</th>
				<th width="15%">
					<?php 
echo JHtml::_('grid.sort', 'JCATEGORY', 'a.catid', $listDirn, $listOrder);
?>
				</th>
				<th width="5%">
					<?php 
echo JHtml::_('grid.sort', 'JGRID_HEADING_LANGUAGE', 'language', $listDirn, $listOrder);
?>
				</th>
				<th width="1%" class="nowrap">
					<?php 
echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder);
?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="6">
					<?php 
echo $this->pagination->getListFooter();
?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php 
foreach ($this->items as $i => $item) {
    ?>
			<tr class="row<?php 
    echo $i % 2;
    ?>">
				<td>
					<a class="pointer" onclick="if (window.parent) window.parent.<?php 
    echo $this->escape($function);
    ?>('<?php 
    echo $item->id;
    ?>', '<?php 
    echo $this->escape(addslashes($item->name));
    ?>');">
						<?php 
    echo $this->escape($item->name);
    ?></a>
				</td>
				<td align="center">
					<?php 
    if (!empty($item->linked_user)) {
        ?>
						<?php 
        echo $item->linked_user;
        ?>
					<?php 
    }
    ?>
				</td>
				<td class="center">
					<?php 
    echo $this->escape($item->access_level);
    ?>
				</td>
				<td class="center">
					<?php 
    echo $this->escape($item->category_title);
    ?>
				</td>
				<td class="center">
					<?php 
    if ($item->language == '*') {
        ?>
						<?php 
        echo JText::alt('JALL', 'language');
        ?>
					<?php 
    } else {
        ?>
						<?php 
        echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED');
        ?>
					<?php 
    }
    ?>
				</td>
				<td align="center">
					<?php 
    echo (int) $item->id;
    ?>
				</td>
			</tr>
			<?php 
}
?>
		</tbody>
	</table>

	<input type="hidden" name="task" value="" />
	<input type="hidden" name="filter_order" value="<?php 
echo $listOrder;
?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php 
echo $listDirn;
?>" />
	<?php 
echo JHtml::_('form.token');
?>
</form>
