var JVTranslate = function (element, options) {
        return this.init(element, options);
    };

(function ($) {
    JVTranslate.prototype = {
        options: {
            mode: 'flag',
            lang: '',
            api: '',
            flagsize: null,
            url: null,
            languages: ''
        },

        init: function (element, options) {
            this.element = element;

            for (var key in options) {
                this.options[key] = options[key];
            }

            if (this.options.api) {
                $.translate.load(this.options.api);

                if (this.options.mode == 'flag') {
                    this.createFlags();

                    if (this.getCurrentLang()) {
                        this.translate(this.getCurrentLang());
                    }

                } else {
                    this.createTranslationBox();
                }
            }

        },
        
        getThis: function(){
        	return this;
        },
        
        createTranslationBox: function () {
            var that = this;
            this.to = this.options.lang ? this.options.lang : 'vi';
            
            if (this.options.languages != '') {
                languages = this.options.languages;
            } else {
                languages = $.translate.getLanguages(true);
            }
            
            this.result = $('<div />', {
                id: 'translate_result'
            });
            
            this.input = $('<textarea />', {
            	id: 'translate_input'
            }).keyup(function () {
            	that.textTranslate(this.value, that.from, that.to);
            });

            var from = $('<select />', {
                name: 'from'
            }).change(function () {
                that.from = this.value;
                that.textTranslate(that.getThis().input[0].value, this.value, that.to);

            }).appendTo(this.element);

            var to = $('<select />', {
                name: 'to'
            }).change(function () {
                that.to = this.value;                
                that.textTranslate(that.getThis().input[0].value, that.from, this.value);

            }).appendTo(this.element);
            
            var op = $('<option />', {
                value: '',
                text: 'Detect language'
            });
            op.appendTo(from);
            
            for (var key in languages) {
                op = $('<option />', {
                    value: languages[key],
                    text: key
                });
                
                op.clone().appendTo(from);                
                if(this.to == languages[key]){
                	op.attr('selected', 'selected');
                	
                }
                op.appendTo(to);
            }
            
            this.input.appendTo(this.element);
            this.result.appendTo(this.element);
        },

        textTranslate: function (text, from, to) {
            var that = this;
            
            console.log(text + ' - ' + from + ' - ' + to);
            
            if(from != ''){
            	 $.translate(text, from, to, {
                     complete: function () {
                         that.result.text(this.translation);
                     }
                 });
            }else{
            	 $.translate(text, to, {
                     complete: function () {
                         that.result.text(this.translation);
                     }
                 });
            }
        },

        createFlags: function () {
            var languages = {};

            if (this.options.languages != '') {
                languages = this.options.languages;
            } else {
                languages = $.translate.getLanguages(true);
            }

            for (var key in languages) {
                var flag = this.createFlag(key, languages[key]);
                flag.appendTo(this.element);
            }

        },

        createFlag: function (lang, code) {
            var that = this;
            var link = url + this.options.flagsize + '/' + code + '.png';
            var a = $('<a />', {
                title: lang,
                href: 'javascript:void(0)'
            }).click(function () {
                that.translate(code, that.getCurrentLang());
            });

            $('<img />', {
                title: lang,
                src: link
            }).appendTo(a);

            return a;
        },

        translate: function (to, from) {
            if (from) {
                $('body').translate(from, to, {
                    toggle: true
                });

            } else {
                $('body').translate(to, {
                    toggle: true
                });
            }

            this.setLang(to);
        },

        setLang: function (val) {
            $.cookies.set('lang', val, {
                expires: 1
            });
        },

        getCurrentLang: function () {
            return $.cookies.get('lang') ? $.cookies.get('lang') : this.options.lang;

        }

    };

})(jQuery);