<?php

/**
 * @package		Joomla.Administrator
 * @subpackage	com_installer
 * @copyright	Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @since		2.5
 */
// no direct access
defined('_JEXEC') or die;
echo JRoute::_('index.php?option=com_installer&view=warnings');
if ($this->errorCount === 0) {
    ?>
    <p class="nowarning"><?php 
    echo JText::_('COM_INSTALLER_MSG_DATABASE_OK');
    ?></p>
	<?php 
    echo JHtml::_('sliders.start', 'database-sliders', array('useCookie' => 1));
    ?>

<?php 
} else {
    ?>
	<p class="warning"><?php 
    echo JText::_('COM_INSTALLER_MSG_DATABASE_ERRORS');
    ?></p>
	<?php 
    echo JHtml::_('sliders.start', 'database-sliders', array('useCookie' => 1));
    ?>

	<?php 
    $panelName = JText::plural('COM_INSTALLER_MSG_N_DATABASE_ERROR_PANEL', $this->errorCount);
    ?>
	<?php 
    echo JHtml::_('sliders.panel', $panelName, 'error-panel');
    ?>
	<fieldset class="panelform">
		<ul>
			<?php 
    if (!$this->filterParams) {
        ?>
				<li><?php 
        echo JText::_('COM_INSTALLER_MSG_DATABASE_FILTER_ERROR');
        ?>
			<?php 
    }
    ?>

			<?php 
    if (!(strncmp($this->schemaVersion, JVERSION, 5) === 0)) {
        ?>
				<li><?php 
        echo JText::sprintf('COM_INSTALLER_MSG_DATABASE_SCHEMA_ERROR', $this->schemaVersion, JVERSION);
        ?></li>
			<?php 
    }
    ?>

			<?php 
    if ($this->updateVersion != JVERSION) {
        ?>
				<li><?php 
        echo JText::sprintf('COM_INSTALLER_MSG_DATABASE_UPDATEVERSION_ERROR', $this->updateVersion, JVERSION);
        ?></li>
			<?php 
    }
    ?>

			<?php 
    foreach ($this->errors as $line => $error) {
        ?>
				<?php 
        $key = 'COM_INSTALLER_MSG_DATABASE_' . $error->queryType;
        $msgs = $error->msgElements;
        $file = basename($error->file);
        $msg0 = isset($msgs[0]) ? $msgs[0] : ' ';
        $msg1 = isset($msgs[1]) ? $msgs[1] : ' ';
        $msg2 = isset($msgs[2]) ? $msgs[2] : ' ';
        $message = JText::sprintf($key, $file, $msg0, $msg1, $msg2);
        ?>
				<li><?php 
        echo $message;
        ?></li>
			<?php 
    }
    ?>
		</ul>
	</fieldset>
<?php 
}
echo JHtml::_('sliders.panel', JText::_('COM_INSTALLER_MSG_DATABASE_INFO'), 'furtherinfo-pane');
echo JText::sprintf('COM_INSTALLER_MSG_DATABASE_SCHEMA_VERSION', $this->schemaVersion);
echo JText::sprintf('COM_INSTALLER_MSG_DATABASE_UPDATE_VERSION', $this->updateVersion);
echo JText::sprintf('COM_INSTALLER_MSG_DATABASE_DRIVER', JFactory::getDbo()->name);
echo JText::sprintf('COM_INSTALLER_MSG_DATABASE_CHECKED_OK', count($this->results['ok']));
echo JText::sprintf('COM_INSTALLER_MSG_DATABASE_SKIPPED', count($this->results['skipped']));
echo JHtml::_('sliders.end');
echo JHtml::_('form.token');